package gov.va.vamf.scheduling.varutility.service;


import gov.va.vamf.scheduling.varutility.domain.*;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CustomRequestSettingsService {

    public CustomRequestSettings createDefaultCustomRequestSettings(List<ClinicalServices> clinicalServices) {
        CustomRequestSettings crs = new CustomRequestSettings();
        for (ClinicalServices service: clinicalServices) {
            String serviceName = service.getName();
            String serviceId = service.getId();
            Integer serviceSubmittedRequestLimit = service.getSubmittedRequestLimit();
            SchedulingDays schedulingDays = new SchedulingDays();
            for (Day d: Day.values()) {
                SchedulingDay schedulingDay = new SchedulingDay();
                schedulingDay.setCanSchedule(false);
                schedulingDay.setDay(d);
                schedulingDay.setStartTime("");
                schedulingDay.setEndTime("");
                schedulingDays.add(schedulingDay);
            }
            crs.add(new CustomRequestSetting(serviceId, serviceName, false, schedulingDays, serviceSubmittedRequestLimit, serviceSubmittedRequestLimit));
        }
        return crs;
    }

    public CustomRequestSettings updateCriteriaCoreSettings(CustomRequestSettings customRequestSettings, List<ClinicalServices> services) {
        Map<String, String> servicesIds = new HashMap<String, String>();
        Map<String, Integer> serviceSubmittedRequestLimits = new HashMap<String, Integer>();

        for (ClinicalServices clinicalService: services) {
            servicesIds.put(clinicalService.getId(), clinicalService.getName());
            serviceSubmittedRequestLimits.put(clinicalService.getId(), clinicalService.getSubmittedRequestLimit());
        }

        for (CustomRequestSetting customRequestSetting: customRequestSettings) {
            String id = customRequestSetting.getId();
            if (customRequestSetting.getSubmittedRequestLimit() == null) {
                customRequestSetting.setSubmittedRequestLimit(serviceSubmittedRequestLimits.get(id));
            }
            customRequestSetting.setTypeOfCare(servicesIds.get(id));
            customRequestSetting.setEnterpriseSubmittedRequestLimit(serviceSubmittedRequestLimits.get(id));
        }
        return customRequestSettings;
    }
}
